### 29.1.1. 连接Redis

你可以注入一个自动配置的RedisConnectionFactory，StringRedisTemplate或普通的跟其他Spring Bean相同的RedisTemplate实例。默认情况下，这个实例将尝试使用localhost:6379连接Redis服务器。
```java
@Component
public class MyBean {

    private StringRedisTemplate template;

    @Autowired
    public MyBean(StringRedisTemplate template) {
        this.template = template;
    }
    // ...
}
```
如果你添加一个你自己的任何自动配置类型的@Bean，它将替换默认的（除了RedisTemplate的情况，它是根据bean的名称'redisTemplate'而不是它的类型进行排除的）。如果在classpath路径下存在commons-pool2，默认你会获得一个连接池工厂。
